/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	WeatherDance
**
** DESCRIPTION:	Weather dance puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef WEATHERDANCE_H
#define WEATHERDANCE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "PuzzleInterface.h"
#include "../Game/GameTimer.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int WeatherDance_c_iMaxDancingBuilders = 5;
const int WeatherDance_c_iMaxDancingFarmers = 5;
const int WeatherDance_c_iBuildersRequired = 3;
const int WeatherDance_c_iFarmersRequired = 3;
const int WeatherDance_c_iTimeToAffectWeather = 15;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWeatherDance : public IPuzzle
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
	};

	//class data
	int			m_iChiefRef;
	int			m_iDancingBuilderRef[WeatherDance_c_iMaxDancingBuilders];
	int			m_iNumDancingBuilders;
	int			m_iDancingFarmerRef[WeatherDance_c_iMaxDancingFarmers];
	int			m_iNumDancingFarmers;
	CGameTimer	m_WeatherTimer;
	
	//class methods
	//setup
	public:		CWeatherDance(void);
	public:		void Reset();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);
	public:		void Complete();

	public:		void AddSparkles(const int iRef) const;

	// access
	public:		const bool IsChiefDancing() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CWeatherDance		WeatherDance;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/